create or replace view money2 as 
SELECT instrutypid, 55 as mem_mmbrtypid, SUM(dealqty)/10000000 AS sumofdeal,
    SUM(dealqty * rate)/10000000 AS sumofdealxrate, MAX(rate) AS maxrate,
    MIN(rate) AS minrate, 'sel' AS buysellind
FROM ms_deal_tbl, m_mmbr_t
WHERE (sllrmmbrid = mem_mmbrid) AND instrutypid IN (8, 9, 10)
    AND mem_mmbrtypid = 4 AND to_char(dealentrdtimestmp,'DD-MM-YYYY') = to_char(sysdate,'DD-MM-YYYY')
    AND dealstts NOT IN ('Q','B','J','E')
GROUP BY instrutypid
UNION
SELECT instrutypid, 55 as mem_mmbrtypid, SUM(dealqty)/10000000 AS sumofdeal,
    SUM(dealqty * rate)/10000000 AS sumofdealxrate, MAX(rate) AS maxrate,
    MIN(rate) AS minrate, 'buy' AS buysellind
FROM ms_deal_tbl, m_mmbr_t
WHERE (byrmmbrid = mem_mmbrid) AND instrutypid IN (8, 9, 10)
    AND mem_mmbrtypid = 4 AND to_char(dealentrdtimestmp,'DD-MM-YYYY') = to_char(sysdate,'DD-MM-YYYY')
    AND dealstts NOT IN ('Q','B','J','E')
GROUP BY instrutypid
UNION
SELECT instrutypid, 66 as mem_mmbrtypid, SUM(dealqty)/10000000 AS sumofdeal,
    SUM(dealqty * rate)/10000000 AS sumofdealxrate, MAX(rate) AS maxrate,
    MIN(rate) AS minrate, 'sel' AS buysellind
FROM ms_deal_tbl, m_mmbr_t
WHERE (sllrmmbrid = mem_mmbrid) AND instrutypid IN (8, 9, 10)
    AND mem_mmbrtypid IN (6,7,8,9,10,11) AND to_char(dealentrdtimestmp,'DD-MM-YYYY') = to_char(sysdate,'DD-MM-YYYY')
    AND dealstts NOT IN ('Q','B','J','E')
GROUP BY instrutypid
UNION
SELECT instrutypid, 66 as mem_mmbrtypid, SUM(dealqty)/10000000 AS sumofdeal,
    SUM(dealqty * rate)/10000000 AS sumofdealxrate, MAX(rate) AS maxrate,
    MIN(rate) AS minrate, 'buy' AS buysellind
FROM ms_deal_tbl, m_mmbr_t
WHERE (byrmmbrid = mem_mmbrid) AND instrutypid IN (8, 9, 10)
    AND mem_mmbrtypid IN (6,7,8,9,10,11) AND to_char(dealentrdtimestmp,'DD-MM-YYYY') = to_char(sysdate,'DD-MM-YYYY')
    AND dealstts NOT IN ('Q','B','J','E')
GROUP BY instrutypid
UNION
SELECT instrutypid, 77 AS mem_mmbrtypid, SUM(dealqty)/10000000
    AS sumofdeal, SUM(dealqty * rate)/10000000 AS sumofdealxrate,
    MAX(rate) AS maxrate, MIN(rate) AS minrate,
    'sel' AS buysellind
FROM ms_deal_tbl, m_mmbr_t
WHERE (sllrmmbrid = mem_mmbrid) AND instrutypid IN (8, 9, 10)
    AND mem_mmbrtypid NOT IN (4,6,7,8,9,10,11) AND to_char(dealentrdtimestmp,'DD-MM-YYYY') = to_char(sysdate,'DD-MM-YYYY')
    AND dealstts NOT IN ('Q','B','J','E')
GROUP BY instrutypid
UNION
SELECT instrutypid, 77 AS mem_mmbrtypid, SUM(dealqty)/10000000
    AS sumofdeal, SUM(dealqty * rate)/10000000 AS sumofdealxrate,
    MAX(rate) AS maxrate, MIN(rate) AS minrate,
    'buy' AS buysellind
FROM ms_deal_tbl, m_mmbr_t
WHERE (byrmmbrid = mem_mmbrid) AND instrutypid IN (8, 9, 10)
    AND mem_mmbrtypid  NOT IN (4,6,7,8,9,10,11) AND to_char(dealentrdtimestmp,'DD-MM-YYYY') = to_char(sysdate,'DD-MM-YYYY')
    AND dealstts NOT IN ('Q','B','J','E')
GROUP BY instrutypid;
/

create or replace view ms_dealsforperd_vw as
SELECT
 Ms_deal_tbl.DealId,
 Ms_deal_tbl.DealEntrdTimeStmp,
 Ms_deal_tbl.DealStts,
 ms_deal_tbl.instruid ,
 i.ITD_Desc as instrunme,
 ui.ITD_Desc as undrlynginstrunme,
 ms_deal_tbl.byrmmbrid,
 ms_deal_tbl.sllrmmbrid,
 b.Mem_Name as buyer,
 s.Mem_Name as seller,
 Ms_deal_tbl.DealQty,
 Ms_deal_tbl.RepoIntrst,
 Ms_deal_tbl.DealPrce,
 Ms_deal_tbl.SecndLegPrce,
 Ms_deal_tbl.YildToMturyOfScrt,
 Ms_deal_tbl.Rate,
 Ms_deal_tbl.Perd,
 Ms_deal_tbl.FirstLegNetCnsdtn,
 Ms_deal_tbl.SecndLegNetCnsdtn,
 Ms_deal_tbl.StlmtDt,
 Ms_deal_tbl.SecndLegStlmtDt,
 Ms_deal_tbl.InstruTypId,
 Ms_deal_tbl.STLMTSTTS,
 Ms_deal_tbl.STLMTTHRU,
 Ms_deal_tbl.SecndLegStlmtDt - Ms_deal_tbl.StlmtDt as period,
 Ms_deal_tbl.ISPRNCPALBYR,
 Ms_deal_tbl.ISPRNCPALSLLR
FROM
    Ms_deal_tbl Ms_deal_tbl,
    M_instru_t i,
    M_instru_t ui,
    M_mmbr_t b,
    M_mmbr_t s
WHERE
   MS_deal_tbl.instruid = i.ITD_instruid AND
   MS_deal_tbl.undrlynginstruid = ui.ITD_instruid (+) AND
   MS_deal_tbl.sllrmmbrid  = s.mem_mmbrid (+) AND
   MS_deal_tbl.byrmmbrid  = b.mem_mmbrid (+);
/

create or replace view ms_dealslip_vw as
SELECT Ms_deal_tbl.*,
    M_baseinstrutyp_t.BIT_Desc AS instrutypnme,
    b.MEM_Name AS byrmmbrnme,
    s.MEM_Name AS sllrmmbrnme, i.ITD_Desc AS instrunme,
    ui.ITD_Desc AS undrlynginstrunme,
    Ms_deal_tbl.SecndLegStlmtDt - Ms_deal_tbl.StlmtDt as period
FROM Ms_deal_tbl,
 M_instru_t i,
 M_instru_t ui,
 M_baseinstrutyp_t,
 M_mmbr_t b,
 M_mmbr_t s
WHERE
Ms_deal_tbl.InstruTypId = M_baseinstrutyp_t.BIT_BaseInstruTypId AND
Ms_deal_tbl.InstruId = i.ITD_InstruId  AND
Ms_deal_tbl.UndrlyngInstruId = ui.ITD_InstruId (+) AND
Ms_deal_tbl.SllrMmbrId = s.MEM_MmbrId (+) AND
Ms_deal_tbl.ByrMmbrId = b.MEM_MmbrId (+);
/

create or replace view ms_SGLform_vw as
select 
 DEALID,              
 s.mem_name as SLLRMMBRNME,
 SLLRSGLACCNO  , 
 b.mem_name as BYRMMBRNME,  
 BYRSGLACCNO,            
 SLLRSIDECNSTNTNME,      
 BYRSIDECNSTNTNME,       
 i.ITD_DESC,               
 i.ITD_ISIN,               
 DEALQTY,                
 DEALPRCE,               
 FIRSTLEGACRDINTRST,
 INSTRUTYPID, 
 DEALENTRDTIMESTMP,           
 STLMTDT,                
 FIRSTLEGTAX            ,
 FIRSTLEGNETCNSDTN      ,
 BYRBRKRID              ,
 BYRBRKRGEAMT           ,
 SLLRBRKRID             ,
 SLLRBRKRGEAMT          ,
 SECNDLEGSTLMTDT,
 RATE                   ,
 SECNDLEGNETCNSDTN  ,
 ui.ITD_DEsc as UNDRLYNGINSTRUNME,
 ui.ITD_ISIN as UNDRLYNGISIN
from ms_deal_tbl,m_instru_t i,m_instru_t ui ,m_mmbr_t b,m_mmbr_t s
where 
ms_deal_tbl.instruid = i.ITD_instruid and
ms_deal_tbl.undrlynginstruid = ui.ITD_instruid(+) and
ms_deal_tbl.sllrmmbrid = s.mem_mmbrid and
ms_deal_tbl.byrmmbrid = b.mem_mmbrid;
/

create or replace view ms_dealflat_vw as
select distinct dealid,sedealid,refdealid,
decode(dealstts,
'E','AA',
'B','AA',
'S','AA',
'Q','RE',
'T','RE',
'J','RE',
'R','RE',
'D','RS',
'N','RS',
'K','RS',
'M','RS',
'I','RS',
'H','DS',
'F','DS',
'A','DS',
'G','RJS',
'Y','RJS',
'U','RJS',
'V','RJS',
'C','RJS',
'Z','RJS') DealStts,
to_char(DealEntrdTimeStmp,'YYYY-MM-DD HH:MI:SS') DealEntrdTimeStmp
,byrmmbrid,sllrmmbrid,byrdlrid,sllrdlrid,b.ITD_ISIN,
b.ITD_GnrcSpc,dealqty,dealprce,
decode(mktid,
1,'W',
3,'W',
5,'R',
8,'O',
9,'O',
10,'O',
0,'O',
decode(sign(0-mktid),1,'O',
          decode(sign(0-mktid),-1,'F')
      )
) TypeOfTrans,
FirstLegGrosCnsdtn, FirstLegAcrdIntrst ,
FirstLegTax,FirstLegNetCnsdtn,
decode(instruid ,
8,rate,
9,rate,
14,rate,
15,rate,
YildToMturyOfScrt) YildToMturyOfScrt,
to_char(stlmtdt,'YYYY-MM-DD') stlmtdt,RepoIntrst,
to_char(SecndLegStlmtDt,'YYYY-MM-DD') SecndLegStlmtDt,
SecndLegPrce,SecndLegGrosCnsdtn,SecndLegAcrdIntrst, SecndLegTax,SecndLegNetCnsdtn,
(select c.ITD_ISIN  from m_instru_t c
 where c.ITD_Instruid = UndrlyngInstruId ) undrlyngISIN ,
(select c.ITD_GnrcSpc
 from m_instru_t c
 where c.ITD_Instruid = UndrlyngInstruId ) undrlyngGnrcSpec,
SllrBrkrId,ByrBrkrId,SllrBrkrgeAmt, ByrBrkrgeAmt,
Perd,isueid,
decode(trdtyp,
'S','SGL-SGL',
'L','SGL-PHY',
'P','PHY-SGL',
'R','CLRCORP',
'C','PHY-PHY',
'N',NULL)
ModeOfDelivery,
ByrSideCnstntNme,SllrSideCnstntNme,
decode(stlmtthru,
'P','PDO Settlement',
'C','CCIL Settlement',
'O','Others')
SettlementThru
FROM ms_deal_tbl a,m_instru_t b
WHERE a.instruid = b.ITD_instruid
AND a.buysellind <>'X';
/

CREATE OR REPLACE PROCEDURE DEAL_FLAT (FNAME VARCHAR,L_DEALSTTSFLAG CHAR,
L_DEALSTTSIN1 CHAR,
L_DEALSTTSIN2 CHAR,
L_DEALSTTSIN3 CHAR,
L_DEALSTTSIN4 CHAR,
L_DEALSTTSIN5 CHAR,
L_DEALSTTSIN6 CHAR,
L_DEALIDRANGEFLAG CHAR,
L_DEALIDSTART NUMBER,
L_DEALIDEND NUMBER,
L_DATERANGEFLAG CHAR,
L_DATESTART DATE,
L_DATEEND DATE
)
AS
CURSOR c_flatfile is
select distinct dealid,sedealid,refdealid,dealstts,to_char(DealEntrdTimeStmp,'YYYY-MM-DD HH:MI:SS') DealEntrdTimeStmp ,byrmmbrid,sllrmmbrid,byrdlrid,sllrdlrid,ITD_ISIN,
ITD_GnrcSpc,dealqty,dealprce,FirstLegGrosCnsdtn, FirstLegAcrdIntrst ,
FirstLegTax,FirstLegNetCnsdtn, YildToMturyOfScrt,rate,instruid,to_char(stlmtdt,'YYYY-MM-DD') stlmtdt,RepoIntrst,to_char(SecndLegStlmtDt,'YYYY-MM-DD') SecndLegStlmtDt,
 SecndLegPrce,SecndLegGrosCnsdtn,SecndLegAcrdIntrst, SecndLegTax,SecndLegNetCnsdtn,
  SllrBrkrId,ByrBrkrId,SllrBrkrgeAmt, ByrBrkrgeAmt,
  Perd,isueid,TrdTyp,ByrSideCnstntNme,SllrSideCnstntNme,mktid,UndrlyngInstruId,instrutypid,stlmttyp,stlmtthru
 FROM ms_deal_tbl,m_instru_t
WHERE
 ms_deal_tbl.instruid = m_instru_t.ITD_instruid
AND ms_deal_tbl.buysellind <> 'X'
AND	((ms_deal_tbl.dealstts IN(L_DEALSTTSIN1,L_DEALSTTSIN2,L_DEALSTTSIN3,L_DEALSTTSIN4,L_DEALSTTSIN5,L_DEALSTTSIN6)) OR 
			 (L_DEALSTTSFLAG = 'Y'))
AND	((ms_deal_tbl.dealid  between  L_DEALIDSTART and L_DEALIDEND ) OR 
			 (L_DEALIDRANGEFLAG = 'Y'))
AND	((TO_DATE(TO_CHAR(ms_deal_tbl.DealEntrdTimeStmp,'DD-MON-YYYY'),'DD-MON-YYYY')  >=  L_DATESTART and TO_DATE(TO_CHAR(ms_deal_tbl.DealEntrdTimeStmp,'DD-MON-YYYY'),'DD-MON-YYYY') <= L_DATEEND ) OR 
			 (L_DATERANGEFLAG = 'Y'));
-- local variables are declared here
TypeOfTrans char;
l_modeofdelivery char(7);
l_stlmtThru char(20);
l_dealstts char(3);
l_undrlyngISIN m_instru_t.ITD_ISIN%TYPE;
l_UndrlyngGnrcSpec m_instru_t.ITD_GnrcSpc%TYPE;
l_handle UTL_FILE.FILE_TYPE;
-- name of file taken as input from the User
BEGIN
 l_handle := UTL_FILE.FOPEN('c:\',FNAME,'w');
FOR flatfile_rec IN c_flatfile
 LOOP
--setting value for type of transaction 
 IF flatfile_rec.mktid = 1 THEN
      TypeOfTrans := 'W';
   ELSIF flatfile_rec.instrutypid = 5 THEN
      TypeOfTrans := 'R';
   ELSIF (flatfile_rec.stlmttyp <= 0 OR flatfile_rec.instrutypid IN(8,9,10)) THEN
      TypeOfTrans := 'O';
   ELSIF flatfile_rec.stlmttyp > 1 THEN
      TypeOfTrans := 'F';
 END IF;
--using the data Call Rate and Repo Rate for instruments Call Money , Repo
IF flatfile_rec.instruid = 8 THEN
	flatfile_rec.YildToMturyOfScrt := flatfile_rec.rate; 
ELSIF flatfile_rec.instruid = 9 THEN
	flatfile_rec.YildToMturyOfScrt := flatfile_rec.rate; 
ELSIF flatfile_rec.instruid = 14 THEN
	flatfile_rec.YildToMturyOfScrt := flatfile_rec.rate; 
ELSIF flatfile_rec.instruid = 15 THEN
	flatfile_rec.YildToMturyOfScrt := flatfile_rec.rate; 
END IF;
--setting the value for dealstts
IF flatfile_rec.dealstts='E' OR flatfile_rec.dealstts='B' OR flatfile_rec.dealstts='S' THEN
   l_dealstts := 'AA';
ELSIF flatfile_rec.dealstts='Q' OR flatfile_rec.dealstts='T' OR flatfile_rec.dealstts='J'  OR flatfile_rec.dealstts='R' THEN
   l_dealstts :='RE';
ELSIF flatfile_rec.dealstts='D' OR flatfile_rec.dealstts='N' OR flatfile_rec.dealstts='K'  OR flatfile_rec.dealstts='M' OR flatfile_rec.dealstts='I' THEN
   l_dealstts :='RS'; 
ELSIF flatfile_rec.dealstts='H' OR flatfile_rec.dealstts='F' THEN
   l_dealstts :='DS'; 
ELSIF flatfile_rec.dealstts='G' OR flatfile_rec.dealstts='Y' OR flatfile_rec.dealstts='U'  OR flatfile_rec.dealstts='V' OR flatfile_rec.dealstts='C' OR flatfile_rec.dealstts='Z' THEN
   l_dealstts :='RJS'; 
END IF;
--setting value for Mode Of delivery
IF flatfile_rec.TrdTyp ='S' THEN
    l_modeofdelivery := 'SGL-SGL';
 ELSIF flatfile_rec.TrdTyp ='L' THEN
    l_modeofdelivery := 'SGL-PHY';
 ELSIF flatfile_rec.TrdTyp ='P' THEN
    l_modeofdelivery := 'PHY-SGL';
 ELSIF flatfile_rec.TrdTyp ='R' THEN
    l_modeofdelivery := 'CLRCORP';
 ELSIF flatfile_rec.TrdTyp ='C' THEN
    l_modeofdelivery := 'PHY-PHY';
 ELSIF flatfile_rec.TrdTyp ='N' THEN
    l_modeofdelivery := NULL;
 END IF;
  IF flatfile_rec.UndrlyngInstruId IS NULL THEN
    l_undrlyngISIN := '';
    l_UndrlyngGnrcSpec := '';
 ELSE
    select  ITD_ISIN,ITD_GnrcSpc INTO l_undrlyngISIN,l_undrlyngGnrcSpec
    from    m_instru_t
    where
     ITD_Instruid = flatfile_rec.UndrlyngInstruId ;
 END IF;
--setting value for Settlement Thru
IF flatfile_rec.StlmtThru ='P' THEN
    l_stlmtThru := 'PDO Settlement';
ELSIF flatfile_rec.StlmtThru ='C' THEN
    l_stlmtThru := 'CCIL Settlement';
ELSIF flatfile_rec.StlmtThru ='O' THEN
    l_stlmtThru := 'Others';
END IF;
 UTL_FILE.PUT_LINE(l_handle, ltrim(flatfile_rec.dealid) || ','|| ltrim(flatfile_rec.sedealid)  || ','|| ltrim(flatfile_rec.refdealid) ||',' || ltrim(l_dealstts) || ',' ||ltrim(flatfile_rec.DealEntrdTimeStmp) || ',' ||
     ltrim(flatfile_rec.byrmmbrid) || ',' ||ltrim(flatfile_rec.sllrmmbrid) || ',' || ltrim(flatfile_rec.byrdlrid) || ',' || ltrim(flatfile_rec.sllrdlrid) || ','  ||ltrim(flatfile_rec.ITD_ISIN) || ',' ||
     rpad(flatfile_rec.ITD_GnrcSpc,16,' ') || ',' ||ltrim(flatfile_rec.dealqty) || ',' ||ltrim(flatfile_rec.dealprce) || ',' ||
     ltrim(TypeOfTrans) || ',' || ltrim(flatfile_rec.FirstLegGrosCnsdtn) || ',' ||  ltrim(flatfile_rec.FirstLegAcrdIntrst)  || ',' ||
     ltrim(flatfile_rec.FirstLegTax) || ',' || ltrim(flatfile_rec.FirstLegNetCnsdtn) || ',' ||  ltrim(flatfile_rec.YildToMturyOfScrt) || ',' ||
     ltrim(flatfile_rec.stlmtdt) || ',' || ltrim(flatfile_rec.RepoIntrst) || ',' || ltrim(flatfile_rec.SecndLegStlmtDt) || ',' ||
     ltrim(flatfile_rec.SecndLegPrce) || ',' || ltrim(flatfile_rec.SecndLegGrosCnsdtn) || ',' || ltrim(flatfile_rec.SecndLegAcrdIntrst) || ',' ||
     ltrim(flatfile_rec.SecndLegTax) || ',' || ltrim(flatfile_rec.SecndLegNetCnsdtn) || ',' ||
     ltrim(l_undrlyngISIN) || ',' ||rpad(l_UndrlyngGnrcSpec,16,' ') || ',' ||ltrim(flatfile_rec.SllrBrkrId) || ',' ||ltrim(flatfile_rec.ByrBrkrId) || ',' ||ltrim(flatfile_rec.SllrBrkrgeAmt) || ',' ||
     ltrim(flatfile_rec.ByrBrkrgeAmt) || ',' ||ltrim(flatfile_rec.Perd) || ',' ||ltrim(flatfile_rec.isueid) || ',' ||
     ltrim(l_modeofdelivery) || ',' || ltrim(flatfile_rec.ByrSideCnstntNme) || ',' ||ltrim(flatfile_rec.SllrSideCnstntNme) || ',' || ltrim(l_stlmtThru));
  END LOOP;
 UTL_FILE.FCLOSE(l_handle);
  COMMIT;
EXCEPTION
WHEN OTHERS THEN
 dbms_output.put_line(SQLERRM);
  END;
/

commit
/

