create table m_balstmt_t_rroriginal as select * from m_balstmt_t
/
delete from m_balstmt_t where bal_isin like 'IN%'
/
update m_balstmt_t set bal_txntyp=0 where bal_txntyp is null
/
update m_balstmt_t set bal_drorcr=0 where bal_drorcr is null
/
delete from m_balstmt_t where bal_seqnum in (
select a.bal_seqnum from m_balstmt_t a,m_balstmt_t b where 
a.bal_isin=b.bal_isin and 
a.bal_acntnum = b.bal_acntnum and
a.bal_txnref = b.bal_txnref and
a.bal_txntyp = b.bal_txntyp and
a.bal_date = b.bal_date and
a.bal_drorcr = b.bal_drorcr and
a.bal_seqnum < b.bal_seqnum
)
/
CREATE TABLE M_BALSTMT_T_RRTEMPORARY
(
  BAL_SEQNUM NUMBER(10),
  BAL_DATE DATE,
  BAL_ACNTNUM CHAR(8),
  BAL_ISIN CHAR(12),
  BAL_BAL NUMBER(20),
  BAL_QTY NUMBER(15,2),
  BAL_TXNREF NUMBER(9),
  BAL_TXNTYP NUMBER(2),
  BAL_DRORCR NUMBER(2),
  BAL_CNTRPRTYID CHAR(8),
  BAL_LASTFLG CHAR(1),
  M_BALSTMT_T_VER NUMBER(2),
  DM_LSTUPDDT DATE,
  PRIMARY KEY (BAL_DATE,BAL_ACNTNUM,BAL_TXNREF,BAL_TXNTYP,BAL_ISIN,BAL_DRORCR)
)
/
insert into m_balstmt_t_rrtemporary select * from m_balstmt_t
/
rename m_balstmt_t to m_balstmt_t_rrbackup
/
rename m_balstmt_t_RRTEMPORARY to M_BALSTMT_T
/
CREATE OR REPLACE VIEW M_BALSMT_VW
(
  SGLACNO,
  BALDATE,
  ISIN,
  NOMENCLATURE,
  GENSPEC,
  BALANCE,
  BASEINSTRUTYP,
  MMBRID,
  MMBRNAME,
  SGLACTYP
)
AS SELECT
M_BALSTMT_T.BAL_ACNTNUM SGLACNO,
M_BALSTMT_T.BAL_DATE BALDATE,
M_INSTRU_T.ITD_ISIN ISIN,
M_INSTRU_T.ITD_DESC NOMENCLATURE,
M_INSTRU_T.ITD_GNRCSPC GENSPEC,
M_BALSTMT_T.BAL_BAL BALANCE,
M_INSTRU_T.ITD_BASEINSTRUTYP BASEINSTRUTYP,
M_SYSGLBLRD_T.SYR_MMBRID MMBRID,
M_MMBR_T.MEM_NAME MMBRNAME,
M_SGLACNT_T.SGL_ACNTTYPID SGLACTYP
FROM
M_BALSTMT_T,
M_INSTRU_T,
M_MMBR_T,
M_SYSGLBLRD_T,
M_SGLACNT_T
WHERE
TRIM(M_BALSTMT_T.BAL_ISIN)=TRIM(TO_CHAR(M_INSTRU_T.ITD_INSTRUID)) AND
M_BALSTMT_T.BAL_LASTFLG = 'Y' AND
M_MMBR_T.MEM_MMBRID = M_SYSGLBLRD_T.SYR_MMBRID AND
M_SGLACNT_T.SGL_ACNTNUM=M_BALSTMT_T.BAL_ACNTNUM
/

CREATE OR REPLACE VIEW M_SMTACT_VW
(
  TRANS_REF,
  TRANS_DATE,
  SGLACNO,
  SGLACTYP,
  ISIN,
  NOMENCLATURE,
  GENSPEC,
  TRANS_TYPE,
  DBCR,
  CPID,
  TRANS_QTY,
  TRANS_BALANCE,
  CPNAME,
  MEM_NAME,
  TRANS_LASTFLAG,
  INSTRUTYP,
  SGL_DESC
)
AS SELECT 
  M_BALSTMT_T.BAL_TXNREF TRANS_REF,
  M_BALSTMT_T.BAL_DATE TRANS_DATE,
  M_BALSTMT_T.BAL_ACNTNUM SGLACNO,
  M_SGLACNT_T.SGL_ACNTTYPID SGLACTYP,
  M_INSTRU_T.ITD_ISIN ISIN,
  M_INSTRU_T.ITD_DESC NOMENCLATURE,
  M_INSTRU_T.ITD_GNRCSPC GENSPEC,
  DECODE((SELECT CODEDES FROM M_CODEVAL_T WHERE CODEID=951 AND TRIM(CODEVALUE)=TRIM(TO_CHAR(BAL_TXNTYP))),NULL,TO_CHAR(BAL_TXNTYP),(SELECT CODEDES FROM M_CODEVAL_T WHERE CODEID=951 AND TRIM(CODEVALUE)=TRIM(TO_CHAR(BAL_TXNTYP)))) TRANS_TYPE,
  M_BALSTMT_T.BAL_DRORCR DBCR,
  M_BALSTMT_T.BAL_CNTRPRTYID CPID,
  M_BALSTMT_T.BAL_QTY TRANS_QTY,
  M_BALSTMT_T.BAL_BAL TRANS_BALANCE,
  DECODE(TRIM(BAL_CNTRPRTYID),NULL,'',(SELECT mem_name FROM M_MMBR_T WHERE TRIM(MEM_MMBRID) = TRIM(BAL_CNTRPRTYID) )) CPNAME,
  SELF_T.MEM_NAME MEM_NAME,
  M_BALSTMT_T.BAL_LASTFLG TRANS_LASTFLAG,
  M_INSTRU_T.ITD_BASEINSTRUTYP INSTRUTYP,
  M_SGLACNT_T.SGL_DESC SGL_DESC
FROM 
  M_BALSTMT_T,
  M_INSTRU_T,
  M_MMBR_T SELF_T,
  M_SGLACNT_T,
  M_SYSGLBLRD_T
WHERE 
  TRIM(M_BALSTMT_T.BAL_ISIN)=TRIM(TO_CHAR(M_INSTRU_T.ITD_INSTRUID)) AND
  M_BALSTMT_T.BAL_ACNTNUM = M_SGLACNT_T.SGL_ACNTNUM AND
  M_SYSGLBLRD_T.SYR_MMBRID = SELF_T.MEM_MMBRID

/
alter view M_BALSMT_VW compile
/
alter view M_SMTACT_VW compile
/
UPDATE MS_AS_ERRMSG_TBL SET errmsg = 'Your request has been submitted. Please check the result after some time and retry the operation if required.' WHERE errcatg=5 AND errcd IN (9510,912694027)
/
commit
/	


